/** la classe processusVente est instanciee apres une requete de vente lancee par l'utilisateur*/

public class ProcessusVente extends Processus{
	
	/**le nom du client qui lance la requete*/
	String _nom;
	/**l'action sur laquelle porte l'operation boursiere*/
	String _action;
	/**le nombre d'actions sur lequel porte la transaction*/
	int _n;
	
	/**on construit un nouveau processus vente le la meme facon que dans la classe processus,
		en ajoutant simplement le nom du client, le nom de l'action et le nombre d'actions
		@see Processus
	*/
	public ProcessusVente(Courtier c,Bourse bo,Banque ba,String nom, String action, int n){
		super(c,bo,ba);
		_nom = nom;
		_action = action;
		_n = n;		
	}
	
	/**la methode run execute la requete de vente, on verifie : <br>
		(1) Que le courtier est pret<br>
		(2) Que le client a assez d'actions disponibles<br>
		On effectue ensuite le transfert d'actions et le virement bancaire, puis un libere le courtier
		Si la requete est impossible a effectuer, alors on affiche un message d'erreur

	*/
	public void run(){
		int dispoClient;
		_courtier.s.P();
		
		try{
		
			dispoClient = _courtier.getDispo(_nom,_action);
			double val = _bourse.valeur(_action);
			
			if ((dispoClient < _n)) throw (new Exception());
			
			sleep(2000);
			
			boolean b =_banque.transfert("Bourse",_nom,val*(double)_n);
			b =_banque.transfert("Bourse","Courtier",val*(double)_n*0.1);
								
			_courtier.decrDispo(_nom,_action,_n);
			double i = _bourse.acheter(_action,_n);
			
			_courtier.s.V();
			stop();
			
		}catch(Exception e){
			_courtier.s.V();
			System.out.println("!   plantage du processus "+_nom+" vend "+_n+" actions "+_action);
			stop();
		}
	}
} 