/** la classe processusachat est instanciee apres une requete d'achat lancee par l'utilisateur*/

public class ProcessusAchat extends Processus{
	
	/**le nom du client qui lance la requete*/
	String _nom;
	/**l'action sur laquelle porte l'operation boursiere*/
	String _action;
	/**le nombre d'actions sur lequel porte la transaction*/
	int _n;


	/**on construit un nouveau processus achat le la meme facon que dans la classe processus,
		en ajoutant simplement le nom du client, le nom de l'action et le nombre d'actions
		@see Processus*/
	public ProcessusAchat(Courtier c,Bourse bo,Banque ba,String nom, String action, int n){
		super(c,bo,ba);
		_nom = nom;
		_action = action;
		_n = n;		
	}

	/**la methode run execute la requete d'achat, on verifie : <br>
		(1) Que le courtier est pret<br>
		(2) Qu'il y a assez d'actions disponibles<br>
		(3) Que le client a assez d'argent<br>
		On effectue ensuite le transfert d'actions et le virement bancaire, puis un libere le courtier
		Si la requete est impossible a effectuer, alors on affiche un message d'erreur
	*/
	public void run(){
		
		/* est ce que le courtier est pret*/
		_courtier.s.P();
		
		int dispoBourse;
		
		try{
			
			dispoBourse = _bourse.nombre(_action);
			double val = _bourse.valeur(_action);
			/*est ce qu'il y a assez d'actions*/	
			if (dispoBourse < _n) throw (new Exception());
			
			/*delai d'attente pour le virement bancaire*/
			sleep(2000);
			/*est ce que le client a assez d'argent*/
			boolean b =_banque.transfert(_nom,"Bourse",val*(double)_n);
			if(!b) throw (new Exception());
			boolean b2 =_banque.transfert(_nom,"Courtier",val*(double)_n*0.1);
			
			if(!b2){ b =_banque.transfert("Bourse",_nom,val*(double)_n);
						throw (new Exception());
					 }
		
			/*virement bancaire*/
			_courtier.incrDispo(_nom,_action,_n);
			double i = _bourse.vendre(_action,_n);
			/*liberation du courtier*/
			_courtier.s.V();
			stop();
	}catch(Exception e){
		/*le processus a plante, pour diverses raisons, soit le client n'a pas assez d'argent, 
			soit il n'y a pas assez d'actions disponibles*/
		_courtier.s.V();
		System.out.println("\033[33m!   plantage du processus "+_nom+" achete "+_n+" actions "+_action+"\033[0m");
		stop();}
	}
} 