import java.io.*;

/**la classe MonAction derive de la classe action et elle en garde 
	toutes les proprietes.
	On a juste rajoute a la definition de Action une valeur.
	On pourra alors modeliser la bourse, vue comme une liste de Monactions
	@see Action
	Ici aussi, la valeur sera une variable critique, car susceptibles d'etre 
	utilisee simultanement par plusieurs processus.
	On se basera donc sur le modele lecteur/redacteur, mais pour la valeur
	on donnera priorit a la lecture, car si un on lance deux achats en 
	meme temps, alors la valeur utilisee par chacun des processus achats
	doit etre la meme
*/

public class MonAction extends Action{

	/*valeur de la Action*/
	protected double _valeur;
	
	
	/* semaphores : on se base sur le modele lecteur redacteur, 
		pour _valeur la lecture a priorite sur l'ecriture
		i.e. getValeur a priorite sur incrValeur et decrValeur
	*/
	protected Semaphore _emValeur;
	protected Semaphore _tourValeur;
	protected Semaphore _fichierValeur;
	protected int _nlValeur;
	
	/**cree une nouvelle MonAction 
		@param nom le nom de l'action
		@param valeur la valeur de l'action
		@param dispo le nombre d'actions disponibles
	*/
	public MonAction(String nom,double valeur,int dispo){
		super(nom,dispo);
		_valeur = valeur;
		_tourValeur = new Semaphore(1);
		_emValeur = new Semaphore(1);
		_fichierValeur = new Semaphore(1);
		_nlValeur=0;
	}
	
	public MonAction(Action a,int valeur){
		super(a.getNom(),a.getDispo());
		_valeur = valeur;
	}
	
	public MonAction(MonAction a){
		super(a.getNom(),a.getDispo());
		_valeur = a.getValeur();
	}	
	
	
	/**processus lecteur il a priorite sur l'ecriture
		@return la valeur de l'action au moment de l'appel a la fonction
	*/
	public double getValeur(){
		double valeur;
		
		_tourValeur.P();
		_emValeur.P();
		_nlValeur++;
		if(_nlValeur==1) _fichierValeur.P();
		_emValeur.V();
		_tourValeur.V();
		valeur = _valeur;
		_emValeur.P();
		_nlValeur--;
		if (_nlValeur==0) _fichierValeur.V();
		_emValeur.V();	
	
		return valeur;
	}
	
	/**processus redacteur
		permet d'augmenter la valeur de l'action
		@param i le prix que l'on veut rajouter a la valeur de l'action
	*/
	public void incrValeur(double i){
		_tourValeur.P();
		_fichierValeur.P();
		_valeur+=i;
		_fichierValeur.V();
		_tourValeur.V();
	}
	
	/**processus redacteur
		permet de diminuer la valeur de l'action
		@param i le prix que l'on veut enlever a la valeur de l'action
	*/
	public void decrValeur(double i){	
		_tourValeur.P();
		_fichierValeur.P();
		_valeur-=i;
		_fichierValeur.V();
		_tourValeur.V();
	}
	
	
	/**lit une action a partir d'un stream tokenizer deja initialise.
		utilise pour l'initialisation de la bourse
		le format de chaque ligne de texte doit etre le suivant :<br>
		X actions Y a Z F
		ou X est un entier, Y une chaine de caracteres et Z un flottant
		@exception IOException declenchee dans le cas d'un probleme d'acces 
		au flux d'entree
		@exception ErreurFichierException declenchee si le fichier est mal formate
	*/		
	public void lire(StreamTokenizer s) throws IOException, ErreurFichierException{
		
		s.eolIsSignificant(true);			
		
		try{	
			//on lit le nombre d'actions X		
			s.nextToken();
			if(s.ttype!=s.TT_NUMBER)
				{throw (new ErreurFichierException());}
			else {
				_dispo=(int)(s.nval);
			}
			
			// on saute le mot action
			s.nextToken();
			
			//on lit le nom de l'action
			s.nextToken();
			
			if(s.ttype!=s.TT_WORD)
				throw (new ErreurFichierException());
			else{
				 _nom=s.sval;
			}
			
			//on saute le mot a
			s.nextToken();
			
			//on lit la valeur de l'action
			s.nextToken();
			
			if(s.ttype!=s.TT_NUMBER)
				throw (new ErreurFichierException());
			else {
				_valeur=(double)(s.nval);
			}
			
			//on saute le mot F et la fin de ligne
			s.nextToken();s.nextToken();
		}catch(IOException e){throw new IOException();}
		
	}
        
        static void main(String [] args){
          	StreamTokenizer st;
			  	ListeTitres ldeb = null;
		      MonAction a = new MonAction("",0.0,0);
				
			  try {
			    InputStream fic = new FileInputStream("resu");
			    Reader r = new BufferedReader(new InputStreamReader(fic));
		       st = new StreamTokenizer(r);
		       
			
				while(st.ttype!=st.TT_EOF){
		       a.lire(st);
		       System.out.println(a.getNom() +" " +a.getDispo()+" "+a.getValeur());
		      }
		      
		     }catch(IOException e){System.out.println("erreur d'ouverture fichier");}
		      catch(ErreurFichierException e){System.out.println("Fichier mal formate");}
		    }



         
         
	 	

		
}