import java.io.*;
import java.util.*;
import java.lang.*;

/**Modelise la Liste d'actions detenues par la bourse
	@see MonAction
*/

public class ListeTitres extends LinkedList{
	
	/**construit une liste vide*/
	public ListeTitres(){
		super();		
	}
	
	/**lit une liste d'actions a partir d'un fichier*/
	public void lire(String fichier) throws FileNotFoundException, IOException, ErreurFichierException{
		StreamTokenizer st;
		MonAction a = new MonAction("",0.0,0);		
			
		try {
		   InputStream fic = new FileInputStream(fichier);
		   Reader r = new BufferedReader(new InputStreamReader(fic));
		   st = new StreamTokenizer(r);
	 	}catch (FileNotFoundException e){throw new FileNotFoundException();}
	 	
	 	a.lire(st);
	 	add(a);
	 		 	
	 	try{
			while(st.ttype!=st.TT_EOF){
	 			a = new MonAction("",0.0,0);		 
	 			a.lire(st);		
	 	 	 	add(a);
	 	 	 }
	 	}catch(IOException e){throw (new IOException());}
		 catch(ErreurFichierException e){throw (new ErreurFichierException());}
	}
	
	/**retourne vrai ssi la liste est vide*/
	public boolean isEmpty(){return(size()==0);}
	
	/** retourne le premier element de la liste*/
	public MonAction premier(){return (MonAction)(getFirst());}
	
	
	/**recherche un titre par son nom*/
	public MonAction recherche(String nom) throws NotInListException{
		int i=0;
		
		while (i<size()){
			MonAction a = (MonAction)(get(i));
		
			if (a.getNom().equals(nom))
				return a;
			else 	i++;
		}
		
		throw (new NotInListException());
	}
	
	/**decremente le nombre d'actions X detenues par la bourse
		@param nom le nom de l'action
		@param n le nombre d'actions a retirer
	*/
	public void decrDispo(String nom, int n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			MonAction a = (MonAction)(get(i));
		
			if (a.getNom().equals(nom)){
				a.decrDispo(n);
				return;
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}
	
	/**incremente le nombre d'actions X detenues par la bourse
		@param nom le nom de l'action
		@param n le nombre d'actions a ajouter
	*/
	public void incrDispo(String nom, int n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			MonAction a = (MonAction)(get(i));
		
			if (a.getNom().equals(nom)){
				a.incrDispo(n);
				return;
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}
	
	/**retourne le nombre d'actions X detenues par la bourse
		@param nom le nom de l'action
	*/
	public int getDispo(String nom) throws NotInListException{
	int i=0;
		
		while (i<size()){
			MonAction a = (MonAction)(get(i));
		
			if (a.getNom().equals(nom)){
				return a.getDispo();
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}


	/**decremente la valeur de l'actions X 
		@param nom le nom de l'action
		@param n la somme a retirer
	*/
		public void decrValeur(String nom, double n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			MonAction a = (MonAction)(get(i));
		
			if (a.getNom().equals(nom)){
				a.decrValeur(n);
				return;
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}
	
	/**dencremente la valeur de l'actions X 
		@param nom le nom de l'action
		@param n la somme a ajouter
	*/
	public void incrValeur(String nom, double n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			MonAction a = (MonAction)(get(i));
		
			if (a.getNom().equals(nom)){
				a.incrValeur(n);
				return;
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}
	
	/**retourne la valeur de l'actions X 
		@param nom le nom de l'action
	*/
	public double getValeur(String nom) throws NotInListException{
	int i=0;
		
		while (i<size()){
			MonAction a = (MonAction)(get(i));
		
			if (a.getNom().equals(nom)){
				return a.getValeur();
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}

	
	/**affiche une liste de titres*/
	public void affiche(){
		int i=0;
		
		while (i<size()){
			MonAction a = (MonAction)(get(i));
			System.out.print("\t"+a.getNom() +" ");
			for(int l=0;l<(20-a.getNom().length());l++)
						System.out.print(".");
			System.out.print(" "+a.getDispo() +" ");
			int d = a.getDispo();
			String s = Integer.toString(d);
			for(int l=0;l < (20 - s.length()) ;l++)
						System.out.print(".");
			System.out.println(" "+a.getValeur());
			
			i++;
		}
	}

	public static void main(String [] args){
		ListeTitres l=new ListeTitres();
		try{
			l.lire("resu");
			l.affiche();
			System.out.println("");
			l.decrDispo("X",20);
			l.decrValeur("Y",20.20);
			l.affiche();
		}catch(IOException e){System.out.println("IOException");}
		 catch(ErreurFichierException e){System.out.println("ErreurFichierException");}		
		 catch(NotInListException e){System.out.println("L'element recherche n'est pas dans la liste");}
	}



}