import java.io.*;
import java.util.*;

/**modelise une liste de clients du courtier*/

public class ListeClientCourtier extends LinkedList{
	/**cree une liste vide*/
	public ListeClientCourtier(){
		super();		
	}
	
	/**retourne vrai si la liste est vide*/
	public boolean isEmpty(){return(size()==0);}
	
	/**retourne le premier element de la liste*/
	public ClientCourtier premier(){return (ClientCourtier)(getFirst());}
			
	/** recherche un client dans la liste par son nom*/
	public ClientCourtier recherche(String nom) throws NotInListException{
		int i=0;
		
		while (i<size()){
			ClientCourtier a = (ClientCourtier)(get(i));
		
			if (a.getNom().equals(nom))
				return a;
			else 	i++;
		}
		
		throw (new NotInListException());
	}
	
	/**decremente le nombre d'actions X detenues par un client
		@param nom le nom du client
		@param action le nom de l'action
		@param n le nombre d'actions a retirer
	*/
	public void decrDispo(String nom, String action, int n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			ClientCourtier a = (ClientCourtier)(get(i));
			
		try{	
			if (a.getNom().equals(nom)){
				a.decrDispo(action,n);
				return;
			}
			else 	i++;
		}catch(NotInListException e){throw (new NotInListException());}
		}
		
		throw (new NotInListException());
	
	}
	
	
	/**incremente le nombre d'actions X detenues par un client
		@param nom le nom du client
		@param action le nom de l'action
		@param n le nombre d'actions a ajouter
	*/
	public void incrDispo(String nom, String action, int n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			ClientCourtier a = (ClientCourtier)(get(i));
		
		try{
			if (a.getNom().equals(nom)){
				a.incrDispo(action,n);
				return;
			}
			else 	i++;
		}catch(NotInListException e){throw (new NotInListException());}
		}
		
		throw (new NotInListException());
	
	}
	
	
	/**retourne le nombre d'actions X detenues par un client
		@param nom le nom du client
		@param action le nom de l'action
	*/
	public int getDispo(String nom, String action) throws NotInListException{
	int i=0;
		
		while (i<size()){
			ClientCourtier a = (ClientCourtier)(get(i));

		try{
			if (a.getNom().equals(nom)){
				return a.getDispo(action);
			}
			else 	i++;
		}catch(NotInListException e){throw (new NotInListException());}
		}
		
		throw (new NotInListException());
	
	}

	/** affiche la liste des clients du courtier*/
	public void affiche(){
		int i=0;
		
		while (i<size()){
			ClientCourtier a = (ClientCourtier)(get(i));
			System.out.println(a.getNom());
			i++;
		}
	}


	/**lit une liste de clients a partir d'un fichier*/
	public void lire(String fichier) throws FileNotFoundException, IOException, ErreurFichierException{
		StreamTokenizer st;
		ClientCourtier a = new ClientCourtier("");		
			
		try {
		   InputStream fic = new FileInputStream(fichier);
		   Reader r = new BufferedReader(new InputStreamReader(fic));
		   st = new StreamTokenizer(r);
	 	}catch (FileNotFoundException e){throw new FileNotFoundException();}
	 	
	 	a.lire(st);
	 	add(a);
	 		 	
	 	try{
			while(st.ttype!=st.TT_EOF){
	 			a = new ClientCourtier("");		 
	 			a.lire(st);		
	 	 	 	add(a);
	 	 	 }
	 	}catch(IOException e){throw (new IOException());}
		 catch(ErreurFichierException e){throw (new ErreurFichierException());}
	}
	
	
	public static void main(String [] args){
		ListeClientCourtier l=new ListeClientCourtier();
		try{
			l.lire("clients");
			l.affiche();
			System.out.println("");
			//l.decrDispo("X",20);
			//l.decrValeur("Y",20.20);
			//l.affiche();
		}catch(IOException e){System.out.println("IOException");}
		 catch(ErreurFichierException e){System.out.println("ErreurFichierException");}		
		// catch(NotInListException e){System.out.println("L'element recherche n'est pas dans la liste");}
	}



	
}