import java.io.*;
import java.util.*;

/**Permet de contenir un ensemble de clientBanque
	 @see LinkedList
	 @see ClientBanque
*/
public class ListeClientBanque extends LinkedList{

	/**construit la liste vide*/
	public ListeClientBanque(){
		super();		
	}
	
	/*retourne vrai si la liste est vide
	public boolean isEmpty(){return(size()==0);}
	
	/**retourne le premier element de la liste*/
	public ClientBanque premier(){return (ClientBanque)(getFirst());}
			
	/*recherche un client par son nom dans la liste*/
	public ClientBanque recherche(String nom) throws NotInListException{
		int i=0;
		
		while (i<size()){
			ClientBanque a = (ClientBanque)(get(i));
		
			if (a.getNom().equals(nom))
				return a;
			else 	i++;
		}
		
		throw (new NotInListException());
	}
	
	/**decremente le compte d'un clientBanque contenu dans la liste
		@param nom le nom du client
		@param  n la somme que l'on veut retirer au compte
	*/
	public void decrCompte(String nom, double n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			ClientBanque a = (ClientBanque)(get(i));
		
			if (a.getNom().equals(nom)){
				a.decrCompte(n);
				return;
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}
	
	/**incremente le compte d'un clientBanque contenu dans la liste
		@param nom le nom du client
		@param  n la somme que l'on veut retirer au compte
	*/
	public void incrCompte(String nom, double n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			ClientBanque a = (ClientBanque)(get(i));
		
			if (a.getNom().equals(nom)){
				a.incrCompte(n);
				return;
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}
	
	/**retourne le compte bancaire d'un individu
		@param nom le nom du clientBanque
	*/
	public double getCompte(String nom) throws NotInListException{
	int i=0;
		
		while (i<size()){
			ClientBanque a = (ClientBanque)(get(i));

			if (a.getNom().equals(nom)){
				return a.getCompte();
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}

	/**affiche la liste*/
	public void affiche(){
		int i=0;
		
		while (i<size()){
			ClientBanque a = (ClientBanque)(get(i));
			if(!(a.getNom().equals("Bourse"))){
				System.out.print("\t"+a.getNom() +" ");
				for(int l=0;l<(20-(a.getNom()).length());l++)
					System.out.print(".");
				 System.out.println(" "+a.getCompte());
			}
			i++;
		}
	}
	
	
	/**remplit une liste a partir d'un fichier*/
	public void lire(String fichier) throws FileNotFoundException, IOException, ErreurFichierException{
		StreamTokenizer st;
		ClientBanque a = new ClientBanque("",0.0);		
			
		try {
		   InputStream fic = new FileInputStream(fichier);
		   Reader r = new BufferedReader(new InputStreamReader(fic));
		   st = new StreamTokenizer(r);
	 	}catch (FileNotFoundException e){throw new FileNotFoundException();}
	 	
	 	a.lire(st);
	 	add(a);
	 		 	
	 	try{
			while(st.ttype!=st.TT_EOF){
	 			a = new ClientBanque("",0.0);		 
	 			a.lire(st);		
	 	 	 	add(a);
	 	 	 }
	 	}catch(IOException e){throw (new IOException());}
		 catch(ErreurFichierException e){throw (new ErreurFichierException());}
	}
	
	
	public static void main(String [] args){
		ListeClientBanque l=new ListeClientBanque();
		try{
			l.lire("clients");
			l.affiche();
			System.out.println("");
			//l.decrDispo("X",20);
			//l.decrValeur("Y",20.20);
			//l.affiche();
		}catch(IOException e){System.out.println("IOException");}
		 catch(ErreurFichierException e){System.out.println("ErreurFichierException");}		
		// catch(NotInListException e){System.out.println("L'element recherche n'est pas dans la liste");}
	}



	
}