import java.io.*;
import java.util.*;

/**Permet de contenir un ensemble d'actions
	 @see LinkedList
	 @see Action
*/
public class ListeActions extends LinkedList{

	/**construit une liste vide*/
	public ListeActions(){
		super();		
	}
			
	/**renvoie vrai si la liste est vide*/
	public boolean isEmpty(){return(size()==0);}
	
	/**renvoie le premier element de la liste*/
	public Action premier(){return (Action)(getFirst());}
	
	
	/**recherche une action par son nom, et renvoie cette action*/
	public Action recherche(String nom) throws NotInListException{
		int i=0;
		
		while (i<size()){
			Action a = (Action)(get(i));
		
			if (a.getNom().equals(nom))
				return a;
			else 	i++;
		}
		
		throw (new NotInListException());
	}
	
	/**decremente la quantite d'une action contenue dans la liste
		@param nom le nom de l'action
		@param n le nombre d'actions a retirer
	*/
	public void decrDispo(String nom, int n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			Action a = (Action)(get(i));
		
			if (a.getNom().equals(nom)){
				a.decrDispo(n);
				return;
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}
	
	/**incremente la quantite d'une action contenue dans la liste
		@param nom le nom de l'action
		@param n le nombre d'actions a retirer
	*/
	public void incrDispo(String nom, int n) throws NotInListException{
	int i=0;
		
		while (i<size()){
			Action a = (Action)(get(i));
		
			if (a.getNom().equals(nom)){
				a.incrDispo(n);
				return;
			}
			else 	i++;
		}
		
		Action b = new Action(nom,n);
		add(b);
	
	}
	
	/**retourne la quantite d'une action contenue dans la liste
		@param le nom de l'action dont on veut connaitre la quantite
		@return le nombre d'actions disponibles
	*/ 
	public int getDispo(String nom) throws NotInListException{
	int i=0;
		
		while (i<size()){
			Action a = (Action)(get(i));
		
			if (a.getNom().equals(nom)){
				return a.getDispo();
			}
			else 	i++;
		}
		
		throw (new NotInListException());
	
	}

	/**affiche une liste d'actions*/
	public void affiche(){
		int i=0;
		
		while (i<size()){
			Action a = (Action)(get(i));
			System.out.println(a.getNom() +" " +a.getDispo());
			i++;
		}
	}

	
}