import java.io.*;
import java.util.*;
import java.lang.*;

public class Ebourse {
	
	private ListeClientCourtier _clientsCourtier;
	private ListeClientBanque _clientsBanque;
	private ListeTitres _titres;
	
	public Bourse _bourse;
	public Courtier _courtier;
	public Banque _banque;
	public ThreadGroup _t;


	public Ebourse(String ficActions, String ficComptes) throws ErreurFichierException{
		try{
			_clientsCourtier = new ListeClientCourtier();
			_clientsBanque = new ListeClientBanque();
		   _titres = new ListeTitres();	
		
			_clientsCourtier.lire(ficComptes);
			_clientsBanque.lire(ficComptes);
			_titres.lire(ficActions);
		
			_bourse = new Bourse(_titres);
			_banque = new Banque(_clientsBanque);
			_courtier = new Courtier("Courtier", _banque.getCompte("Courtier"), _clientsCourtier);
			_t = new ThreadGroup("truc");
			}catch(NotInListException e){System.exit(0);}
		 catch(ErreurFichierException e){throw (new ErreurFichierException());}
		 catch(IOException e){throw (new ErreurFichierException());}

	}

	/**renvoie un processus a partir d'une String
		de la forme<br>
		<tt>Pierre achete 10 actions Microsoft</tt> ou <tt>Pierre achete 10 actions Microsoft</tt>
	*/
	public Thread processusOfString(String s) throws OperationIllegaleException{
		
		StringTokenizer st = new StringTokenizer(s);
		
		if (st.countTokens() == 4){
			String nomIndividu= st.nextToken();
			String typeOrdre = st.nextToken();
			int nbActions = Integer.parseInt(st.nextToken());
			String nomAction = st.nextToken();
			
			if (typeOrdre.equals("achete")){
					return (new ProcessusAchat(_courtier,_bourse,_banque,nomIndividu,nomAction,nbActions));
			}
			if (typeOrdre.equals("vend")){
					return (new ProcessusVente(_courtier,_bourse,_banque,nomIndividu,nomAction,nbActions));
			}
		}
		
		throw (new OperationIllegaleException());
	}
	
	
		
	/**lit les requetes dans l'entree standard et lance les processus adequats*/
	public static void main(String [] args){
		/* on recupere les fichiers passes en parametres*/
		String ficActions = args[0];
		String ficComptes = args[1];
		
		Ebourse ebourse;
		try{
			/*initialisation du programme*/
			ebourse = new Ebourse(ficActions,ficComptes);
			
			System.out.println("\033[2J");
			/*initialisation de l'entree standard*/
			BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));      
			while(true){
				try{
					//System.out.print("--> ");
					/**on lit une ligne*/
					String s = stdin.readLine();
					
					/*cas ou on veut voir la valeur des actions*/
					if(s.equals("actions"))	((ebourse)._bourse).affiche();
					else{
					
					/*cas ou on veut voir  la valeur des comptes clients*/
						if(s.equals("comptes"))	((ebourse)._banque).affiche();
						
						/*cas ou on veut quitter le programme*/
						else if(s.equals("exit")){
							System.out.println("    EXIT");
							int nbactive = ebourse._t.activeCount();
							while (nbactive > 0) {
								if (ebourse._t.activeCount() != nbactive){
										nbactive = ebourse._t.activeCount();
								} 
							};
							System.out.println();
							ebourse._banque.affiche();
							System.out.println();
							ebourse._bourse.affiche();
							System.exit(0);
						}
						else{
						/* cas oou on lance une operation boursiere*/
							Thread p = new Thread(ebourse._t,ebourse.processusOfString(s));
							p.start();
						}
					}
				}catch(OperationIllegaleException e){}
			}
		}catch(IOException e){System.exit(0);}
		 catch(ErreurFichierException e){System.exit(0);}
		 
		
	}
}
		
		