/** definit la classe qui gere le courtier.<br>
	Un courtier ne peut pas realiser plus de 5 operations  la fois, 
	On a donc une semaphore initialisee a 5*/

public class Courtier extends ClientBanque{
	
	
	/** la liste des clients du courtier*/
	ListeClientCourtier _clients;
	
	/**la semaphore qui permet de bloquer le courtier afin qu'il ne 
		realise pas plus de 5 operations meme temps
	*/
	public Semaphore s;
	
	
	public Courtier(String nom,double compte){
		super(nom,compte);
		s = new Semaphore(5);
	}
	
	/**construit un courtier
		@param nom le nom du courtier
		@param compte son compte en banque
		@param l Une liste de ClientCourtier
	*/
	public Courtier(String nom, double compte, ListeClientCourtier l){
		super(nom,compte);
		_clients = l;
		s = new Semaphore(5);
	}
	
	/**Decremente le nombre d'actions X chez le client
		@param nom le le nom du client
		@param action le nom de l'action
		@param n le nombre d'actions
	*/
	public void decrDispo(String nom, String action, int n) throws OperationIllegaleException{
		try{
			_clients.decrDispo(nom,action,n);
		}catch(NotInListException e){throw (new OperationIllegaleException());}
	}
	
	/**incremente le nombre d'actions X chez le client
		@param nom le le nom du client
		@param action le nom de l'action
		@param n le nombre d'actions
	*/
	public void incrDispo(String nom, String action, int n) throws OperationIllegaleException{
		try{
			_clients.incrDispo(nom,action,n);
		}catch(NotInListException e){throw (new OperationIllegaleException());}
	}
	
	/**@param nom le le nom du client
		@param action le nom de l'action
		@param n le nombre d'actions
		@return le nombre d'actions demandees chez le client
	*/
	public int getDispo(String nom, String action) throws OperationIllegaleException{
			
		try{
			return _clients.getDispo(nom,action);
		}catch(NotInListException e){throw (new OperationIllegaleException());}
	}
	
}	
		