import java.io.*;

/**modelise un individu quelconque muni d'un carnet d'actions*/
public class ClientCourtier extends Quidam{
	
	/**Une liste d'actions*/
	private ListeActions _carnet;
	
	/**Construit un nouveau clientCourtier avec un carnet d'actions vide
		@param nom le nom du nouveau clientCourtier
	*/
	public ClientCourtier(String nom){
		super(nom);
		_carnet = new ListeActions();
	}
	
	/**decremente le nombre d'actions X dans le carnet du client
		@param nom le nom de l'action
		@param n le nombre d'actions que l'on veut supprimer
	*/
	public void decrDispo(String nom, int n) throws NotInListException{
		try{
			_carnet.decrDispo(nom,n);	
		}catch(NotInListException e){throw (new NotInListException());}
	}
	
	/**incremente le nombre d'actions X dans le carnet du client
		@param nom le nom de l'action
		@param n le nombre d'actions que l'on veut ajouter
	*/
	public void incrDispo(String nom, int n) throws NotInListException{
		try{
			_carnet.incrDispo(nom,n);	
		}catch(NotInListException e){throw (new NotInListException());}
	}
	
	/**permet d'obtenir le nombre d'actions X disponibles dans le carnet d'actions
		@param nom le nom de l'action
	*/
	public int getDispo(String nom) throws NotInListException{
		try{
			return _carnet.getDispo(nom);
		}catch(NotInListException e){throw (new NotInListException());}
	}

	/**lit un ClientCourtier a partir d'un stream tokenizer deja initialise.
		on ne garde que le nom du client
		@ param s Un StreamTokenizer deja initialise dans la procedure appelante
	*/
	public void lire(StreamTokenizer s) throws IOException, ErreurFichierException{
		
		s.eolIsSignificant(true);			
		
		try{	
			//on lit le nom		
			s.nextToken();
			if(s.ttype!=s.TT_WORD)
				{throw (new ErreurFichierException());}
			else {
				_nom=s.sval;
			}
			
			// on saute le mot a
			s.nextToken();
			
			//on saute le solde du compte
			s.nextToken();
							
			//on saute le mot F et la fin de ligne
			s.nextToken();s.nextToken();
		}catch(IOException e){throw new IOException();}
		
	}
	
}