import java.io.*;

/** la classe clientBanque derive de quidam, elle en garde toutes les proprietes
	on a rajoute a la classe mere le champ _compte qui represente le compte
	en banque <br>
	Ce compte en banque est susceptible d'etre partage par plusieurs processus
	nous l'avons donc protege par des semaphores, en suivant le modele lecteur/redacteur
	avec priorit au redacteur
	@see Quidam
*/

public class ClientBanque extends Quidam{
	/**le compte en banque*/
	protected double _compte;
	
	protected Semaphore _tourdispo;
	protected Semaphore _emdispo;
	protected Semaphore _fichierdispo;
	protected int _nldispo;
	
		
	
	/**cree un nouveau ClientBanque
		@param nom le nom du client
		@param compte son compte en banque
	*/
	public ClientBanque(String nom, double compte){
			super(nom);
			_compte = compte;
			_tourdispo = new Semaphore(1);
			_emdispo = new Semaphore(1);
			_fichierdispo = new Semaphore(1);
			_nldispo=0;
	}
	
	/**processus lecteur
		@return le compte en banque
	*/
	public double getCompte(){
		double compte;
		
		_tourdispo.P();
		_emdispo.P();
		_nldispo++;
		if(_nldispo==1) _fichierdispo.P();
		_emdispo.V();
		_tourdispo.V();
		compte = _compte;
		_emdispo.P();
		_nldispo--;
		if (_nldispo==0) _fichierdispo.V();
		_emdispo.V();	
	
		return compte;
	}
	
	
	/**processus redacteurs
		augmente le solde du compte
		@param i l'increment
	*/
	public void incrCompte(double i){
		_tourdispo.P();
		_fichierdispo.P();
		_compte+=i;
		_fichierdispo.V();
		_tourdispo.V();		
	}
	
	/**processus redacteurs
		diminue le solde du compte
		@param i l'increment
	*/
	public void decrCompte(double i){
		_tourdispo.P();
		_fichierdispo.P();
		_compte-=i;
		_fichierdispo.V();
		_tourdispo.V();		
	}
	
	
	
	/**lit une action a partir d'un stream tokenizer deja initialise.
		utilise pour l'initialisation de la banque
		Chaque ligne de texte doit avoir le format suivant:<br>
		X a Y F ou X est une chaine de caracteres et Y est un flottant
	*/
	public void lire(StreamTokenizer s) throws IOException, ErreurFichierException{
		
		s.eolIsSignificant(true);			
		
		try{	
			//on lit le nom		
			s.nextToken();
			if(s.ttype!=s.TT_WORD)
				{throw (new ErreurFichierException());}
			else {
				_nom=s.sval;
			}
			
			// on saute le mot a
			s.nextToken();
			
			//on lit le solde du compte
			s.nextToken();
			
			if(s.ttype!=s.TT_NUMBER)
				throw (new ErreurFichierException());
			else{
				 _compte=s.nval;
			}
				
			//on saute le mot F et la fin de ligne
			s.nextToken();s.nextToken();
		}catch(IOException e){throw new IOException();}
		
	}
	
	static void main(String [] args){
          	StreamTokenizer st;
			  	ListeClientBanque ldeb = null;
		      ClientBanque a = new ClientBanque("",0.0);
				
			  try {
			    InputStream fic = new FileInputStream("clients");
			    Reader r = new BufferedReader(new InputStreamReader(fic));
		       st = new StreamTokenizer(r);
		       
			
				while(st.ttype!=st.TT_EOF){
		       a.lire(st);
		       System.out.println(a.getNom() +a.getCompte());
		      }
		      
		     }catch(IOException e){System.out.println("erreur d'ouverture fichier");}
		      catch(ErreurFichierException e){System.out.println("Fichier mal formate");}
		    }
	
	
}