/**la classe Bourse est censee modeliser la bourse, c'est  dire
 	qu'elle seule permet d'acceder aux cours des actions, a leur nombre
*/

public class Bourse extends ClientBanque{
	
	/**La liste des actions avec leurs valeurs*/
	private ListeTitres _actions;
	
		
	public Bourse(){
		super("Bourse",Double.MAX_VALUE);
	}
	
	/**construit une bourse a partir d'une ListeTitres*/
	public Bourse(ListeTitres l){
		super("Bourse",Double.MAX_VALUE);
		_actions = l;
	}
	
	/**permet d'acceder au compte bancaire de la bourse*/
	public double getCompte(){return _compte;}
	
	/**pour incrementer le compte de la bourse 
		(en realit cette operation est vide, 
		le compte de la bourse etant fixe
	*/
	public void incrCompte(double d){}
	/**pour decrementer le compte de la bourse 
		(en realit cette operation est vide, 
		le compte de la bourse etant fixe
	*/
	public void decrCompte(double d){}
	
	
	/**retourne la valeur actuelle (au moment de l'appel) d'une action
		@param nom le nom de l'action
	*/
	public double valeur(String nom) throws NotInListException{
		try{
			return _actions.getValeur(nom);
		}catch(NotInListException e){throw (new NotInListException());}
	}
	
	/**retourne la quantite actuelle (au moment de l'appel) d'une action
		@param nom le nom de l'action
	*/
	public int nombre(String nom) throws NotInListException{
		try{
			return _actions.getDispo(nom);
		}catch(NotInListException e){throw (new NotInListException());}
	}
	
	/**le nombre d'actions X dans la bourse diminue, et sa valeur augmente
		@param nom le nom de l'action
		@param n le nombre d'actions vendues
	*/
	public double vendre(String nom, int n) throws OperationIllegaleException, NotInListException{
		try{
			double val = valeur(nom);
			
			double dispo = nombre(nom);
			
			if (dispo<n) throw(new OperationIllegaleException());
			else{
				double incrementval = val * ((double)((double)n/1500.0));
				_actions.decrDispo(nom,n);
				_actions.incrValeur(nom,incrementval);
				return(val);
			}
		}catch(NotInListException e){throw (new NotInListException());}
	}
	
	
	/**le nombre d'actions X dans la bourse augmente, et sa valeur diminue
		@param nom le nom de l'action
		@param n le nombre d'actions achetees
	*/
	public double acheter(String nom, int n) throws OperationIllegaleException, NotInListException{
		try{
			double val = valeur(nom);
			double dispo = nombre(nom);
			
			double decrementval = val * ((double)((double)n/1500.0));
			_actions.incrDispo(nom,n);
			_actions.decrValeur(nom,decrementval);
			return(val);
		}catch(NotInListException e){throw (new NotInListException());}
	}
	
	/**affiche le cours de toutes les actions*/
	public void affiche(){_actions.affiche();}
		
}	
		
	