/**modelise la Banque, <br>
	la seule operation autorisee est le transfert
*/

public class Banque{
	
	/** une Liste de ClientsBanque (individus + courtier + bourse)*/
	private ListeClientBanque _clients;
	
	/**initialise une banque a partir d'une liste de clients */
	public Banque(ListeClientBanque l){
		_clients = l;
		_clients.add((ClientBanque)(new Bourse()));
	}
	
	/**permet d'acceder au compte d'un client
		@param nom le nom du client
		@exception NotInListException declenchee au cas ou le client 
		recherche n'est pas dans la liste
	*/
	public double getCompte(String nom) throws NotInListException{
		try{
			return _clients.getCompte(nom);
		}catch (NotInListException e){throw (new NotInListException());}
	}
	
	
	/** effectue le transfert d'argent entre deux clients, et renvoie vrai 
		si l'operation a reussi
		@param d le nom du client debite
		@param a le nom du client credite
		@param s la somme a transferer
	*/
	public boolean transfert(String d, String a, double s){
		try{
			double compted = getCompte(d);
			if(compted<s) return false;
			else {
				_clients.decrCompte(d,s);
				_clients.incrCompte(a,s);
			}
			return true;
		}catch (Exception e){return false;}
	}
	
	/**affiche les comptes de tous les clients de la banque excepte la bourse*/
	public void affiche(){_clients.affiche();}
}