/**
	La classe actions a pour but de modeliser une action, dfinie par son nom et par
	sa quantite.
	
	Elle est destinee a tre stockee dans une liste chez chaque individu pour representer
	un carnet d'actions.
	
	Lorsque un individu voudra vendre ou acheter des actions, alors son carnet d'actions 
	sera modifi, en particulier si l'action sur laquelle porte l'operation existe dja dans le 
	carnet, alors seule sa quantit va changer.
	
	Pour eviter les conflits nous avons introduit des smaphores sur la quantit d'actions 
	disponibles

	<b> semaphores :</b> on se base sur le modele lecteurs/redacteurs pour acceder 
	 a la quantite d'actions X disponibles
	Ici on donne priorite a l'ecriture sur la lecture (i.e incrDispo et decrDispo ont priorit sur getDispo)
	En effet, si un individu effectue deux ventes simultanees de la meme action, il
	faut que le nombre d'action resultant de la premiere operation soit verifie
	@see MonAction
	*/


public class Action{
	
   /** Nom de l'action */
	protected String _nom;
	/** Nombre d'actions disponibles*/
	protected int _dispo;
	
	
	
	protected Semaphore _tourdispo;
	protected Semaphore _emdispo;
	protected Semaphore _fichierdispo;
	protected int _nldispo;
	
		
	
	/**Cree une nouvelle action
		@param nom Le nom de l'action
		@param dispo le nombre d'actions disponibles
	*/
	public Action(String nom,int dispo){
		_nom = nom;
		_dispo = dispo;
		
		_tourdispo = new Semaphore(1);
		_emdispo = new Semaphore(1);
		_fichierdispo = new Semaphore(1);
		_nldispo=0;
	}
	
	
	/*
	public Action(Action a){
		_nom = a.getNom();
		_dispo = a.getDispo();
	}
	*/
	
	/**@return le nom de l'action concernee*/
	public String getNom(){return _nom;}
	
	
	/**
		Processus lecteur, on se base sur le modele lecteur/redacteur, 
		avec priorit pour le redacteur.
		@return le nombre d'actions disponibles
	*/ 
	public int getDispo(){
		int dispo;
		
		_tourdispo.P();
		_emdispo.P();
		_nldispo++;
		if(_nldispo==1) _fichierdispo.P();
		_emdispo.V();
		_tourdispo.V();
		dispo = _dispo;
		_emdispo.P();
		_nldispo--;
		if (_nldispo==0) _fichierdispo.V();
		_emdispo.V();	
	
		return dispo;
	}
		
	/**Processus redacteur, il a priorit sur le processus lecteur
		Il permet d'augmenter le nombre d'actions X
		@param i Le nombre d'actions que l'on veut ajouter
	*/
		
	public void incrDispo(int i){
		_tourdispo.P();
		_fichierdispo.P();
		_dispo+=i;
		_fichierdispo.V();
		_tourdispo.V();		
	}
	
	/**Processus redacteur, il a priorit sur le processus lecteur
		Il permet dde diminuer le nombre d'actions X
		@param i Le nombre d'actions que l'on veut retrancher
	*/
	public void decrDispo(int i){
		_tourdispo.P();
		_fichierdispo.P();
		_dispo-=i;
		_fichierdispo.V();
		_tourdispo.V();		
	}
}
	