
/* Le courtier est un Thread car c'est une solution pour attendre
 * la fin de tous les threads lancs pour excuter les requtes
 * (en testant activeCount) */

import java.io.*;
import java.util.*;

public class Courtier extends Thread {

    Banque banque;
    Bourse bourse;
    Hashtable actions;  // actions dtenues par les clients
    Hashtable locks;    // un smaphore par action et par client
    Semaphore limit;    // smaphore pour limiter  5 les requtes simultanes
    static Random rand = new Random();

    // Un courtier est cr  partir d'une banque et d'une bourse
    // La table des actions des clients est initialement vide
    public Courtier(Banque ba, Bourse bo) {
	banque = ba;
	bourse = bo;
	limit = new Semaphore(5);
	actions = new Hashtable();
	locks = new Hashtable();
    }

    // la mthode achat exige le smaphore limit, puis cre un thread
    // de la classe Achat et le lance; le smaphore limit sera libr
    // par le thread
    public void achat(String c, int n, String a) {
	limit.P();
	(new Achat(c,n,a)).start();
    }
    
    // La sous-classe Achat hrite de la classe Thread 
    // C'est elle qui ralise vraiment l'achat
    class Achat extends Thread {
	String c;
	int n;
	String a;
	String transaction;
	public Achat(String client, int nombre, String action) {
	    c = client; n = nombre; a = action;
	    transaction = c + " achte " + n + " " + a;
	}
	public void run() {
	    System.out.println("  => courtier: dmarrage " + transaction);
	    // on commence par vrouiller l'action 
	    Semaphore sem = sem_action(c,a);
	    sem.P();
	    double val = bourse.acheter(a,n);
	    pause(0,3);
	    if (val == -1) { 
		// la bourse refuse; rien  faire
		echec(transaction);
	    } else {
		// le client paye les actions  la bourse
		boolean t1 = banque.transfert(c,"bourse",val);
		pause(1,4);
		if (! t1) { 
		    // le transfert a chou => on rend les actions  la bourse
		    echec(transaction);
		    bourse.vendre(a,n);
		} else {
		    // le client paye sa commission au courtier
		    boolean t2 = banque.transfert(c,"courtier",0.1 * val);
		    pause(0,2);
		    if (! t2) {
			// le transfert a chou => on rembourse le client
			// et on rend les actions  la banque
			echec(transaction);
			banque.transfert("bourse",c,val);
			bourse.vendre(a,n);
			pause(1,3);
		    } else {
			// succs de la transaction
			mise_a_jour(c,a,n);
			succes(transaction);
		    }
		}
	    }
	    // on libre l'action et le smaphore limit
	    sem.V();
	    limit.V();
	}
    }

    // la mthode vente exige le smaphore limit, puis cre un thread
    // de la classe Vente et le lance; le smaphore limit sera libr
    // par le thread
    public void vente(String c, int n, String a) {
	limit.P();
	(new Vente(c,n,a)).start();
    }
    
    // La sous-classe Vente hrite de la classe Thread 
    // C'est elle qui ralise vraiment la vente
    class Vente extends Thread {
	String c;
	int n;
	String a;
	String transaction;
	public Vente(String client, int nombre, String action) {
	    c = client; n = nombre; a = action;
	    transaction = c + " vend " + n + " " + a;
	}
	public void run() {
	    System.out.println("  => courtier: dmarrage " + transaction);
	    // on commence par vrouiller l'action 
	    Semaphore sem = sem_action(c,a);
	    sem.P();
	    // la seule chose  vrifier est que le client possde
	    // les dites actions
	    int nb = nombre(c,a);
	    if (n > nb) {
		System.out.println("  => courtier : " + c + " ne possde pas "
				    + n + " actions " + a);
		echec(transaction);
	    } else {
		// on revend les actions  la bourse
		double val = bourse.vendre(a,n);
		// on met  jour les actions du client
		mise_a_jour(c,a,-n);
		// on  paye le client
		banque.transfert("bourse",c,0.9 * val);
		pause(0,5);
		// on touche la commission
		banque.transfert("bourse","courtier",0.1 * val);
		succes(transaction);
	    }
	    // on libre l'action et le smaphore limit
	    sem.V();
	    limit.V();
	}
    }

    // annonce l'chec d'une transation
    void echec(String transaction) {
	System.out.println("  => courtier : chec " + transaction);
    }

    // annonce le succs d'une transation
    void succes(String transaction) {
	System.out.println("  => courtier : succs " + transaction);
    }

    // retourne le nombre d'units de l'action a du client c
    int nombre(String c, String a) {
	if (! actions.containsKey(c)) { return 0; }
	Hashtable actions_c = (Hashtable) actions.get(c);
	if (! actions_c.containsKey(a)) { return 0; }
	return ((Integer) actions_c.get(a)).intValue();
    }

    // retourne le smaphore de l'action a du client c
    Semaphore sem_action(String c, String a) {
	Hashtable locks_c;
	if (locks.containsKey(c)) {
	    locks_c = (Hashtable) locks.get(c);
	} else {
	    locks_c = new Hashtable();
	}
	Semaphore sem;
	if (locks_c.containsKey(a)) {
	    sem = (Semaphore) locks_c.get(a);
	} else {
	    sem = new Semaphore(1);
	    locks_c.put(a, sem);
	}
	locks.put(c,locks_c);
	return sem;
    }
	    
    // modifie de n le nombre d'units de l'action a du client c
    void mise_a_jour(String c, String a, int n) {
	Hashtable actions_c;
	// ce client a-t-il une entre ; si non, lui crer une table vide
	if (actions.containsKey(c)) {
	    actions_c = (Hashtable) actions.get(c);
	} else {
	    actions_c = new Hashtable();
	}
	// ce client a-t-il dj des actions a
	if (actions_c.containsKey(a)) {
	    int nb = ((Integer) actions_c.get(a)).intValue();
	    actions_c.put(a, new Integer(nb + n));
	} else {
	    actions_c.put(a, new Integer(n));
	}
	// mise  jour de la table actions
	actions.put(c,actions_c);
    }

    // La mthode interaction lance la boucle d'interaction du courtier
    // Celle-ci lit les commandes sur l'entre standard et excute les
    // requtes correspondantes
    public void run() {
	BufferedReader st = 
	    new BufferedReader(new InputStreamReader(System.in));
	try {
	    prompt();
	    for (String l; (l = st.readLine()) != null; ) {
		StringTokenizer t = new StringTokenizer(l);
		try {
		    String s = t.nextToken();
		    if (s.equals("quitte")) {
			throw (new IOException());
		    } else if (s.equals("actions")) {
			bourse.affiche();
			affiche();
		    } else if (s.equals("soldes")) {
			banque.affiche();
		    } else {
			String c = s;
			String com = t.nextToken();
			int n = (new Integer(t.nextToken())).intValue();
			String a = t.nextToken();
			if (com.equals("achete")) { achat(c,n,a); }
			else if (com.equals("vend")) { vente(c,n,a); }
			else syntaxe();
		    }
		} 
		catch (NoSuchElementException e) { syntaxe (); }
		catch (NumberFormatException e) { syntaxe (); }
		prompt();
	    }
	} catch (IOException e) {}
	while (activeCount() > 2) { 
	    System.out.println("  => courtier : " + 
			       "on attend les dernires requtes");
	    pause(1,1);
	}
	banque.affiche();
	bourse.affiche();
	affiche();
    }

    void prompt() { System.out.println("Courtier > "); }

    void syntaxe() { System.out.println("  => Erreur de syntaxe"); }

    // attend un nombre de secondes alatoires entre min et max inclus
    void pause(int min, int max) { 
	int sec = min + rand.nextInt(max - min + 1);
	try { sleep(1000 * sec); } catch (InterruptedException e) {}; 
    }

    // affiche les actions dtenues par tous les clients
    void affiche() {
	System.out.println("Actions dtenues par les clients :");
	for (Enumeration e = actions.keys() ; e.hasMoreElements() ;) {
	    String c = (String) e.nextElement();
	    System.out.println("  " + c + " :");
	    Hashtable actions_c = (Hashtable) actions.get(c);
	    for (Enumeration ea = actions_c.keys() ; ea.hasMoreElements() ;) {
		String a = (String) ea.nextElement();
		int n = ((Integer) actions_c.get(a)).intValue();
		System.out.println("    " + n + " " + a);
	    }
	}
    }

}
