
import java.io.*;
import java.util.*;

public class Bourse {

    Hashtable nb_actions;    // table de hash action -> nombre (Integer)
    Hashtable val_actions;   // table de hash action -> valeur (Double)
    Hashtable sem_actions;   // table de hash action -> smaphore (Semaphore)

    // Une bourse est cre  partir d'un fichier donnant les actions initiales
    public Bourse(String fichier) {
	nb_actions = new Hashtable();
	val_actions = new Hashtable();
	sem_actions = new Hashtable();
	lire(fichier); 
    }

    // vrifie qu'une action existe
    boolean verifie_action(String a) {
	if (! nb_actions.containsKey(a)) {
	    System.out.println("  => bourse: pas d'action " + a);
	    return false; 
	}
	return true;
    }

    // retourne la valeur d'une action
    public double valeur(String a) {
	if (verifie_action(a)) { 
	    return ((Double) val_actions.get(a)).doubleValue(); 
	}
	return -1;
    }

    // retourne le nombre d'units d'une action
    public int nombre(String a) {
	if (verifie_action(a)) { 
	    return ((Integer) nb_actions.get(a)).intValue(); 
	}
	return -1;
    }

    // la mthode acheter diminue le nombre d'units de l'action a de n,
    // met  jour sa valeur et retourne la valeur totale de l'achat
    public double acheter(String a, int n) {
	// on vrifie tout d'abord que l'action a existe
	if (! verifie_action(a)) { return -1; }
	// on vrouille l'action
	Semaphore sem = (Semaphore) sem_actions.get(a);
	sem.P();
	// on vrifie qu'il y en a assez
	int nb = ((Integer) nb_actions.get(a)).intValue();
	if (n > nb) {
	    System.out.println("  => bourse: pas assez d'action " + a);
	    return -1;
	}
	// on change le nombre d'actions et on modifie sa valeur
	nb_actions.put(a, new Integer(nb - n));
	double val = ((Double) val_actions.get(a)).doubleValue();
	val_actions.put(a, new Double(val + val * 0.01 * n/15));
	// on dvrouille l'action
	sem.V();
	return n*val;
    }

    // la mthode vendre augmente le nombre d'units de l'action a de n,
    // met  jour sa valeur et retourne la valeur totale de la vente
    public double vendre(String a, int n) {
	// on vrifie tout d'abord que l'action a existe
	if (! verifie_action(a)) { return -1; }
	// on vrouille l'action
	Semaphore sem = (Semaphore) sem_actions.get(a);
	sem.P();
	// on change le nombre d'actions et on modifie sa valeur
	int nb = ((Integer) nb_actions.get(a)).intValue();
	nb_actions.put(a, new Integer(nb + n));
	double val = ((Double) val_actions.get(a)).doubleValue();
	val_actions.put(a, new Double(val - val * 0.01 * n/15));
	// on dvrouille l'action
	sem.V();
	return n * val;
    }

    // lecture des actions initiales dans un fichier
    private void lire(String fichier) {
	try { 
	    BufferedReader st = new BufferedReader(new FileReader(fichier));
	    for (String l; (l = st.readLine()) != null;) {
		StringTokenizer t = new StringTokenizer(l);
		Integer n = new Integer (t.nextToken());
		t.nextToken();
		String action = t.nextToken();
		t.nextToken();
		Double v = new Double(t.nextToken());
		nb_actions.put(action,n);
		val_actions.put(action,v);
		sem_actions.put(action, new Semaphore(1));
	    }
	} catch (FileNotFoundException e) {
	    System.out.println("Erreur: fichier " + fichier + " inexistant");
	    System.exit(1);
	} catch (IOException e) {
	    System.out.println("Erreur dans le fichier d'actions " + fichier);
	    System.exit(1);
	} 
    }

    // affiche toutes les actions dtenues par la bourse
    public void affiche() {
	System.out.println("Actions dtenues par la bourse :");
	for (Enumeration e = nb_actions.keys() ; e.hasMoreElements() ;) {
	    String k = (String) e.nextElement();
	    Integer n = (Integer) nb_actions.get(k);
	    Double s = (Double) val_actions.get(k);
	    System.out.println("  "+ n + " actions " + k +" a "+ s +" F");
	}
    }
} 
