
import java.io.*;
import java.util.*;

public class Banque {

    Hashtable soldes;   // table de hash individu -> solde (Double)
    Hashtable locks;    // table de hash individu -> smaphore (Semaphore)

    // Une banque est cre  partir d'un fichier donnant les soldes initiaux
    public Banque(String fichier) {
	soldes = new Hashtable();
	locks = new Hashtable();
	lire(fichier); 
	soldes.put("bourse", new Double(0)); // solde bidon pour la bourse
	locks.put("bourse", new Semaphore(1));
    }

    // La mthode transfert est appele pour effectuer un transfert
    // de la somme s du compte de d vers le compte a
    // Elle retourne un boolen indiquant si le transfert a eu lieu
    public boolean transfert(String d, String a, double s) {
	boolean resultat = false;
	// on vrifie tout d'abord que les clients d et a existent bien
	if (! soldes.containsKey(d)) {
	    System.out.println("  => banque : pas de client " + d);
	    return false;
	}
	if (! soldes.containsKey(a)) {
	    System.out.println("  => banque : pas de client " + d);
	    return false;
	}
	// on commence par un retrait vrouill de s sur le solde de d
	// si cela est possible ; autrement resultat est laiss  faux
	Semaphore semd = (Semaphore) locks.get(d);
	semd.P();
	double solded = ((Double) soldes.get(d)).doubleValue();
	if (d.equals("bourse") || solded - s >= 0) { 
	    soldes.put(d, new Double(solded-s)); 
	    resultat = true; 
	} else {
	    System.out.println("  => banque : " + 
			       d + " n'a pas assez d'argent");
	}
	semd.V();
	// si le retrait a fonctionn alors on effectue un dpt
	// vrouill de s sur le solde de a
	if (resultat) {
	    Semaphore sema = (Semaphore) locks.get(a);
	    sema.P();
	    double soldea = ((Double) soldes.get(a)).doubleValue();
	    soldes.put(a, new Double(soldea+s)); 
	    sema.V();
	    System.out.println("  => banque : transfert de " + s + 
			       " F de " + d + "  " + a + " effectu");
	}
	return resultat;
    }

    // lecture des soldes initiaux dans un fichier
    private void lire(String fichier) {
	try {
	    BufferedReader st = new BufferedReader(new FileReader(fichier));
	    for (String l; (l = st.readLine()) != null;) {
		StringTokenizer t = new StringTokenizer(l);
		String nom = t.nextToken();
		if (nom.equals("Le")) { nom = "courtier"; t.nextToken(); };
		t.nextToken();
		Double solde = new Double(t.nextToken());
		soldes.put(nom,solde);
		locks.put(nom, new Semaphore(1));
	    }
	} catch (FileNotFoundException e) {
	    System.out.println("Erreur: fichier " + fichier + " inexistant");
	    System.exit(1);
	} catch (IOException e) {
	    System.out.println("Erreur dans le fichier bancaire " + fichier);
	    System.exit(1);
	} 
    }

    // affiche les soldes de tous les comptes
    public void affiche() {
	System.out.println("Soldes :");
	for (Enumeration e = soldes.keys() ; e.hasMoreElements() ;) {
	    String k = (String) e.nextElement();
	    Double s = (Double) soldes.get(k);
	    System.out.println("  " + k + " a " + s + " F");
	}
    }
} 
