
/* La classe Semaphore. */

public class Semaphore {
  private int value;

  public Semaphore(int n) {
    value = n;
  }

  public synchronized void P() {
    while (value <= 0) {
      try { wait(); } catch (InterruptedException e) {};
    };
    value--;
  }

  public synchronized void V() {
    value++;
    notifyAll();
  }
}
public class Feu extends Thread {

  private String etat = "Rouge";

  static public double duree_minimale_vert;
  static public double duree_orange;
  static public double securite;

  public Feu(String str, int v, int o, int s) {
    super(str);
    duree_minimale_vert = v;
    duree_orange = o;
    securite = s;
  }

  public void pause(double sec) {
    try { sleep((long)(sec * 1000)); } catch (InterruptedException e) {};
  }

  public String etat_une_lettre () {
    if (etat.equals("Rouge"))
      return "R";
    else if (etat.equals("Vert"))
      return "V";
    else
      return "O";
  }

  public String couleur() {
    return (this.getName() + " " + etat);
  }

  public void change_couleur(String c) {
    etat = c;
  }
}
public class FeuSimple extends Feu {

  private Semaphore sem1;
  private Semaphore sem2;
  private CarrefourSimple cf;
  
  public FeuSimple(String str, int v, int o, int s,
		   Semaphore s1, Semaphore s2, CarrefourSimple c) {
    super(str,v,o,s);
    sem1 = s1;
    sem2 = s2;
    cf = c;
  }

  public void run() {
    while (true) {
      sem1.P();
      change_couleur("Vert"); cf.affichage();
      pause(duree_minimale_vert);
      change_couleur("Orange"); cf.affichage();
      pause(duree_orange);
      change_couleur("Rouge"); cf.affichage();
      pause(securite);
      sem2.V();
    }
  }
}
public class CarrefourSimple {

  private FeuSimple f1,f2;
  private Semaphore sem1,sem2;

  long depart = System.currentTimeMillis();

  public void affichage () {
    long t = (System.currentTimeMillis() - depart) / 1000;
    System.out.println
      ("Temps " + t + " \t" + f1.couleur() + " \t" + f2.couleur());
  }

  public CarrefourSimple (int v, int o, int s) {
    sem1 = new Semaphore(1);
    sem2 = new Semaphore(0);
    f1 = new FeuSimple("Feu 1",v,o,s,sem1,sem2,this);
    f2 = new FeuSimple("Feu 2",v,o,s,sem2,sem1,this);
    f1.start();
    f2.start();
  }
}
public class FeuPetiteRoute extends Feu {

  private Semaphore sem1;
  private Semaphore sem2;
  private Semaphore decl2;
  private CarrefourDeclencheur cf;
  
  public FeuPetiteRoute(String str, int v, int o, int s,
			Semaphore s1, Semaphore s2, Semaphore d2,
			CarrefourDeclencheur c) {
    super(str,v,o,s);
    sem1 = s1;
    sem2 = s2;
    decl2 = d2;
    cf = c;
  }

  public void run() {
    while (true) {
      sem1.P();
      change_couleur("Vert"); cf.affichage();
      pause(duree_minimale_vert);
      change_couleur("Orange"); cf.affichage();
      pause(duree_orange);
      change_couleur("Rouge"); cf.affichage();
      pause(securite);
      sem2.V();
      decl2.V();
    }
  }
}
public class FeuGrandeRoute extends Feu {

  private Semaphore sem1;
  private Semaphore sem2;
  private Semaphore decl1;
  private CarrefourDeclencheur cf;
  
  public FeuGrandeRoute(String str, int v, int o, int s,
			Semaphore s1, Semaphore s2, Semaphore d1,
			CarrefourDeclencheur c) {
    super(str,v,o,s);
    sem1 = s1;
    sem2 = s2;
    decl1 = d1;
    cf = c;
  }

  public void run() {
    while (true) {
      sem1.P();
      change_couleur("Vert"); cf.affichage();
      pause(duree_minimale_vert);
      decl1.P();
      change_couleur("Orange"); cf.affichage();
      pause(duree_orange);
      change_couleur("Rouge"); cf.affichage();
      pause(securite);
      sem2.V();
    }
  }
}

public class Declencheur extends Thread {

  private Semaphore decl1,decl2;

  public Declencheur(Semaphore d1, Semaphore d2) { 
    decl1 = d1;
    decl2 = d2;
  }

  private void pause(double sec) {
    try { sleep((long)(sec * 1000)); } catch (InterruptedException e) {};
  }

  public void run() {
    while (true) {
      decl2.P();
      pause(4 + (long)(Math.random() * 10));
      System.out.println("Une voiture arrive...");
      decl1.V();
    }
  }
}
public class CarrefourDeclencheur {

  private FeuGrandeRoute f1;
  private FeuPetiteRoute f2;
  private Semaphore sem1,sem2,decl1,decl2;

  long depart = System.currentTimeMillis();

  public void affichage () {
    long t = (System.currentTimeMillis() - depart) / 1000;
    System.out.println
      ("Temps " + t + " \t" + f1.couleur() + " \t" + f2.couleur());
  }

  public CarrefourDeclencheur (int v, int o, int s) {
    sem1 = new Semaphore(1);
    sem2 = new Semaphore(0);
    decl1 = new Semaphore(0);
    decl2 = new Semaphore(1);
    f1 = new FeuGrandeRoute("Grande route",v,o,s,sem1,sem2,decl1,this);
    f2 = new FeuPetiteRoute("Petite route",v,o,s,sem2,sem1,decl2,this);
    f1.start();
    f2.start();
    (new Declencheur(decl1,decl2)).start();
  }
}
public class FeuAvenue extends Feu {

  private Semaphore sem1;
  private Semaphore sem2;
  private Semaphore max;
  private Avenue av;
  
  public FeuAvenue(String str, int v, int o, int s,
		   Semaphore s1, Semaphore s2, Semaphore m,
		   Avenue a) {
    super(str,v,o,s);
    sem1 = s1;
    sem2 = s2;
    max = m;
    av = a;
  }

  public void run() {
    while (true) {
      sem1.P();
      change_couleur("Vert"); av.affichage();
      pause(duree_minimale_vert);
      max.P();
      change_couleur("Orange"); av.affichage();
      pause(duree_orange);
      change_couleur("Rouge"); av.affichage();
      pause(securite);
      sem2.V();
    }
  }
}
public class FeuRue extends Feu {

  private Semaphore sem1;
  private Semaphore sem2;
  private Semaphore max;
  private Avenue av;
  
  public FeuRue(String str, int v, int o, int s,
		Semaphore s1, Semaphore s2, Semaphore m,
		Avenue a) {
    super(str,v,o,s);
    sem1 = s1;
    sem2 = s2;
    max = m;
    av = a;
  }

  public void run() {
    while (true) {
      sem1.P();
      change_couleur("Vert"); av.affichage();
      pause(duree_minimale_vert);
      max.V();
      change_couleur("Orange"); av.affichage();
      pause(duree_orange);
      change_couleur("Rouge"); av.affichage();
      pause(securite);
      sem2.V();
    }
  }
}
public class Avenue {

  private FeuAvenue f1[];
  private FeuRue f2[];
  private Semaphore sem1[], sem2[], max;
  private int n;

  long depart = System.currentTimeMillis();

  public void affichage () {
    long t = (System.currentTimeMillis() - depart) / 1000;
    System.out.print("Temps " + t);
    for (int i = 0; i<n; i++) {
      System.out.print(" \t" + f1[i].etat_une_lettre() + "/" + 
		       f2[i].etat_une_lettre());
    };
    System.out.println("");
  }

  public Avenue (int v, int o, int s, int vn, int k) {
    n = vn;
    f1 = new FeuAvenue[n];
    f2 = new FeuRue[n];
    sem1 = new Semaphore[n];
    sem2 = new Semaphore[n];
    max = new Semaphore(k);
    for (int i=0; i<n; i++) {
      sem1[i] = new Semaphore(1);
      sem2[i] = new Semaphore(0);
      f1[i] = new FeuAvenue("Av. "+i,v,o,s,sem1[i],sem2[i],max,this);
      f2[i] = new FeuRue("Rue "+i,v,o,s,sem2[i],sem1[i],max,this);
      f1[i].start();
      f2[i].start();
    };
  }
}
