
.SUFFIXES: .fng .dvi .tex .md5 .aux .toc .bbl .idx .log .ps

.PHONY: .fng

%.dvi: %.tex
	rm -f $*.dvi
	[ -f .tex_$*.tocmd5 ] \
	|| md5sum $*.toc $*.bbl >.tex_$*.tocmd5 2>/dev/null \
	|| true
	[ -f .tex_$*.md5 ] \
	|| md5sum $*.aux $*.toc $*.idx $*.bbl > .tex_$*.md5 2>/dev/null \
	|| true
	while [ ! -f $*.dvi ]; \
	do \
	mv -f .tex_$*.tocmd5 .tex_$*.tocmd5.old; \
	mv -f .tex_$*.md5 .tex_$*.md5.old; \
	latex $*.tex </dev/null; \
	! grep --quiet "End of file on the terminal" $*.log || exit 1; \
	bibtex $*; \
	md5sum $*.toc $*.bbl >.tex_$*.tocmd5 2>/dev/null; \
	cmp .tex_$*.tocmd5 .tex_$*.tocmd5.old || (echo diff; rm -f $*.dvi); \
	 [ -f $*.dvi ] \
	 && ! `grep -v --quiet 'LaTeX Warning: .* Rerun' $*.log` \
	 && echo "No LaTeX warning" && exit; \
	md5sum $*.aux $*.toc $*.idx $*.bbl > .tex_$*.md5 2>/dev/null; \
	cmp --quiet .tex_$*.md5 .tex_$*.md5.old || rm -f $*.dvi; \
	done	

%.md5:
	touch $*.fng
	mv -f $*.fng .tex_$*.fng
	md5sum $* > $*.fng 2>/dev/null || true

%.ps: %.dvi
	dvips $* -o $*.ps

.PHONY: cleantex

cleantex:
	rm -f *.aux *.log *~ .tex_*.md5 .tex_*.fng *.fng .tex_*.tocmd5
	rm -f .tex_*.md5.old .tex_*.tocmd5.old
	rm -f *.bbl *.blg *.idx *.toc *.dvi *.lof

clean:: cleantex
#
