(*
  Corrig du devoir.
*)

(*
\input{macros.tex}
 *)

open Form

(*s \textbf{Fonction d'intrt gnral.}

[ajoute : 'a list -> 'a]

[ajoute x l] ajoute [x]  la liste [l] s'il n'y appartient pas dj
*)
let ajoute x l =
  if List.mem x l then l else x::l

(*s
  \textbf{Les littraux.}

  [{ nom = p ; positif = b }] reprsente [p] si [b=true], [(! p)] sinon.
*)
type littral =
    { nom : string ;
      positif : bool }

(* L'oppos d'un [littral] *)
let oppos { nom = p ; positif = b } = { nom = p ; positif = not b }

(*s
  \textbf{Les formules propositionnelles en forme normale de ngation~:}
*)
type fnn =
  | Ou_fnn of fnn * fnn
  | Et_fnn of fnn * fnn
  | Littral of littral

(*s
  \textbf{Affichage.}
  [print_fnn f] affiche [f]
*)
let rec print_fnn f =
  match f with
    | Ou_fnn(a, b) ->
	print_string "(";
	print_fnn a;
	print_string "|";
	print_fnn b;
	print_string ")"
    | Et_fnn(a, b) ->
	print_string "(";
	print_fnn a;
	print_string "&";
	print_fnn b;
	print_string ")"
    | Littral { nom = p ; positif = b } ->
	if b then print_string p
	else print_string ("(! " ^ p ^ ")")

(*s
  \textbf{Forme normale de ngation symtrique.}
  On appelle forme normale de ngation symtrique d'une formule $a$ tout
  couple $(f, g)$ de formules tel que
  \begin{itemize}
  \item $f$ et $g$ sont en forme normale de ngation ;
  \item $f$ est logiquement quivalente  $a$ ;
  \item $g$ est logiquement quivalente  $(!\ a)$.
  \end{itemize}
*)

(*
   Le type [fnn_sym] sera utilis pour reprsenter les formes
   normales de ngation symtriques.
*)

type fnn_sym = fnn * fnn

(*s
  \textbf{Oprations logiques lmentaires sur [fnn_sym].}
*)

let ou (f1, g1) (f2, g2) = Ou_fnn(f1, f2), Et_fnn(g1, g2)

let non (f1, g1) = (g1, f1)

let et fs1 fs2 = non (ou (non fs1) (non fs2)) (* loi de De Morgan *)

let imp fs1 fs2 = ou (non fs1) fs2

let quiv fs1 fs2 = et (imp fs1 fs2) (imp fs2 fs1)

let atome p = Littral { nom = p ; positif = true },
              Littral { nom = p ; positif = false }

(*s
  \textbf{Calcul d'une [fnn_sym].}
  L'algorithme utilis se fonde sur une dmonstration que toute
  formule [f] admet une [fnn_sym] par induction sur la formule considre.
*)

(*
[fnn_sym f] calcule  la fois une fnn de [f] et de [(! f)]
*)
let rec fnn_sym (f : formule) : fnn_sym =
  match f with
    | Ou(a, b) -> ou (fnn_sym a) (fnn_sym b)
    | Et(a, b) -> et (fnn_sym a) (fnn_sym b)
    | Imp(a, b) -> imp (fnn_sym a) (fnn_sym b)
    | Equiv(a, b) -> quiv (fnn_sym a) (fnn_sym b)
    | Non a -> non (fnn_sym a)
    | Lettre p -> atome p

(*s
  \textbf{Calcul d'une [fnn].}
  Une fois la [fnn_sym] calcule, le calcul de la [fnn] est trivial :
*)

let fnn f = fst (fnn_sym f)


(*s \textbf{Noeuds des tableaux.}
  Il s'agit d'ensembles de formules en forme normale de ngation.
  On y distingue les formules qui sont des littraux et qui n'ont plus
  besoin d'tre traites.

  Invariants que l'on prservera :
  \begin{itemize}
  \item [fnns] est une liste sans rptition.
  \item [littraux] est une liste sans rptition.
  \item [littraux] est toujours satisfiable.
  \end{itemize}
*)

type noeud =
    { littraux : littral list ;
      fnns : fnn list }

(*s
  [rfute noeud] renvoie [()] si [noeud] admet une rfutation.
   Sinon, elle lve l'exception [Modle ll] pour signifier
   que la liste de littraux [ll] a un modle
   et que tout modle de [ll] est un modle de [noeud].
*)
exception Modle of littral list

let rec rfute (n : noeud) : unit =
  match n with
    | { littraux = l; fnns = [] } -> raise (Modle l)
    | { littraux = l; fnns = Ou_fnn(a, b)::r } ->
	rfute { littraux = l; fnns = ajoute a r };
	rfute { littraux = l; fnns = ajoute b r }
    | { littraux = l; fnns = Et_fnn(a, b)::r } ->
	rfute { littraux = l; fnns = ajoute a (ajoute b r) }
    | { littraux = l; fnns = Littral lit :: r } ->
        (* si [(oppos lit)] $\in$ [l], le noeud [n] est rfut *)
	if not (List.mem (oppos lit) l) (* sinon, il faut continuer *)
	then let l' = ajoute lit l in
	rfute { littraux = l'; fnns = r }

(*
  [modle f] vaut [None] si [f] est rfutable, [Some m] si [f] admet
   un modle, o [m] est la liste des littraux  rendre vrai.
*)
let modle (f : fnn) : littral list option =
  try rfute { littraux = []; fnns = [f] }; None
  with
    | Modle m -> Some m



(*s
  [main ()] effectue le traitement demand dans l'nonc
*)
let main () =
  let f = Formanalyse.analyse () in
  let fnn = fnn f in
  print_string "FNN\n";
  print_fnn fnn;
  print_newline ();
  match modle fnn with
    | None -> print_string "INSATISFIABLE\n"
    | Some m ->
	begin
	  print_string "SATISFIABLE\n";
	  List.iter (fun { nom = p ; positif = b } ->
		       begin
			 print_string p;
			 if b then print_string " V\n"
			 else print_string " F\n"
		       end)
	    m
	end
;;

main ();;
