(*
 *  Analyse Lexicale pour les formules propostionnelles
 *  Ceci est un fichier CAMLLEX.
 *)

{
open Lexing;;
open Formsyn;;

exception Lex_error;;
}

rule next_token = parse
  | '&'   {AND}
  | '|'   {OR}
  | '!'   {NOT}
  | "->"  {IMPL}
  | "<->" {EQUIV}
  | '('   {PARG}
  | ')'   {PARD}
  | ['a'-'z''A'-'Z']*  {NAME (lexeme lexbuf)}
  | [' ''\n''\t''\r']* {next_token lexbuf}
  | eof   {FIN}
  | _     {raise Lex_error}


